
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1003.C - Message 1003 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1003 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1003.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:44   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.4   Jul 09 1997 10:36:52   COLEJ
//    
//   
//      Rev 1.3   Feb 12 1997 16:05:16   COLEJ
//    
//   
//      Rev 1.2   Aug 14 1996 09:30:06   COLEJ
//   Repositioned sequence number up one.
//   
//   
//      Rev 1.0   13 May 1996 14:52:42   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "labmon.h"
#include "util.h" 
#include "display.h"

short VisSatPos[32];

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1003 message from the ZMsgBuf.
//      
void Dec1003(tMSGBUF *ZMsgBuf, tMSG1003 *Msg)
{  
   tSHORT i;

   GetShort  (&Msg->SequenceNumber     , ZMsgBuf,  8);     // ND  
   GetUShort (&Msg->GDOP               , ZMsgBuf,  9);     // 1E+02 * ND
   GetUShort (&Msg->PDOP               , ZMsgBuf, 10);     // 1E+02 * ND
   GetUShort (&Msg->HDOP               , ZMsgBuf, 11);     // 1E+02 * ND
   GetUShort (&Msg->VDOP               , ZMsgBuf, 12);     // 1E+02 * ND
   GetUShort (&Msg->TDOP               , ZMsgBuf, 13);     // 1E+02 * ND
   GetUShort (&Msg->NumVisSats         , ZMsgBuf, 14);     // ND
                              
   for(i=0; i<GI_NUM_HW_CHAN; i++)  {  
   GetUShort (&Msg->VisSat[i].PRN      , ZMsgBuf, 15+3*i); // ND
   GetShort  (&Msg->VisSat[i].Azimuth  , ZMsgBuf, 16+3*i); // 1E+04 * radians    
   GetShort  (&Msg->VisSat[i].Elevation, ZMsgBuf, 17+3*i); // dBHz     
   }                                              
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1003 message in the ZMsgBuf. 
//
void Bld1003(tMSGBUF *ZMsgBuf, tMSG1003 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                       , ZMsgBuf, 1);         // message preamble
   PutShort  (1003                         , ZMsgBuf, 2);         // message number
   PutShort  (0                            , ZMsgBuf, 3);         // message length 
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);         // header check sum
 
   //PutShort  (CheckSum(ZMsgBuf, 6, 197)       , ZMsgBuf, 203);   // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1003 message from the ZMsgBuf.
//      
void Show1003(tMSG1003 *Msg)
{  
   char    Buf[80] = ""; 
   float   Azimuth[GI_MAX_VIS_SVS];
   tSHORT  i;
   
   // convert values  
   
   // perform special processing for output
   for(i=0; i < (short) Msg->NumVisSats; i++){
      Azimuth[i] = (float) (Msg->VisSat[i].Azimuth * R42D);
      if(Azimuth[i] < 0){
         Azimuth[i] +=  360;
      }
   } 
                                                   
   // output the data values
   sprintf(Buf,"%05d"  ,Msg->SequenceNumber          );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   
   sprintf(Buf,"%6.2f" ,Msg->GDOP             / 1E+02);ShowText(Buf,DOPR+ 1,DOPC+ 4);
   sprintf(Buf,"%6.2f" ,Msg->PDOP             / 1E+02);ShowText(Buf,DOPR+ 2,DOPC+ 4);
   sprintf(Buf,"%6.2f" ,Msg->HDOP             / 1E+02);ShowText(Buf,DOPR+ 3,DOPC+ 4);
   sprintf(Buf,"%6.2f" ,Msg->VDOP             / 1E+02);ShowText(Buf,DOPR+ 4,DOPC+ 4);
   sprintf(Buf,"%6.2f" ,Msg->TDOP             / 1E+02);ShowText(Buf,DOPR+ 5,DOPC+ 4);
   sprintf(Buf,"%2d"   ,Msg->NumVisSats              );ShowText(Buf,DOPR- 1,DOPC+ 8);
                 
   for(i=0; i < 32; i++)VisSatPos[i] = -1;

   for(i=0; i < (short) Msg->NumVisSats; i++){
   VisSatPos[Msg->VisSat[i].PRN-1] = i;
   sprintf(Buf,"%2d"   ,Msg->VisSat[i].PRN           );ShowText(Buf,VISR+ i,VISC   );
//   sprintf(Buf,"%5.1f",Msg->VisSat[i].Elevation*R42D);ShowText(Buf,VISR+ i,VISC+ 3);
//   sprintf(Buf,"%4.0f",Azimuth[i]                   );ShowText(Buf,VISR+ i,VISC+10);
   sprintf(Buf,"%3d",(short)(Msg->VisSat[i].Elevation*R42D));ShowText(Buf,VISR+ i,VISC+2);
   sprintf(Buf,"%3d",(short)Azimuth[i]                     );ShowText(Buf,VISR+ i,VISC+6);
   }
   
   // clear remaining space
   while(i < GI_NUM_HW_CHAN){
      ShowText("               ",VISR+ i++,VISC);
   }  
}
